/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.generator.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.generator.GeneratorModule;
import mcjty.deepresonance.modules.generator.block.EnergyCollectorTileEntity;
import mcjty.deepresonance.modules.generator.util.GeneratorConfig;
import mcjty.deepresonance.setup.ClientSetup;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.DelayedRenderer;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.client.RenderSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;

public class CollectorRenderer
implements BlockEntityRenderer<EnergyCollectorTileEntity> {
    private static final RenderSettings SETTINGS = RenderSettings.builder().color(255, 0, 0).renderType(CustomRenderTypes.TRANSLUCENT_LIGHTNING_NOLIGHTMAPS).width(0.1f).alpha(200).build();
    private static final RenderSettings SETTINGS_LASER = RenderSettings.builder().width(0.1f).alpha(128).build();
    private final Random random = new Random();

    public CollectorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static void register() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)GeneratorModule.TYPE_ENERGY_COLLECTOR.get()), CollectorRenderer::new);
    }

    public void render(@Nonnull EnergyCollectorTileEntity tileEntity, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (tileEntity.getCrystals().isEmpty() || !tileEntity.areLasersActive() && tileEntity.getLaserStartup() <= 0) {
            return;
        }
        DelayedRenderer.addRender((RenderType)RenderType.m_110466_(), (BlockPos)tileEntity.m_58899_(), (stack, buf) -> {
            this.renderHalo((PoseStack)stack, (VertexConsumer)buf);
            this.renderLasers(tileEntity.m_58899_(), tileEntity.getLaserStartup(), tileEntity.getCrystals(), (PoseStack)stack, (VertexConsumer)buf);
        });
    }

    private void renderHalo(PoseStack matrixStack, VertexConsumer buffer) {
        RenderHelper.renderSplitBillboard((PoseStack)matrixStack, (VertexConsumer)buffer, (float)1.0f, (Vec3)new Vec3(0.0, 0.25, 0.0), (ResourceLocation)ClientSetup.HALO);
    }

    private void renderLasers(BlockPos pos, int laserStartup, Set<BlockPos> crystals, PoseStack matrixStack, VertexConsumer builder) {
        float startupFactor = (float)laserStartup / (float)((Integer)GeneratorConfig.STARTUP_TIME.get()).intValue();
        for (BlockPos destination : crystals) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(ClientSetup.LASERBEAMS[this.random.nextInt(4)]);
            int tex = pos.m_123341_();
            int tey = pos.m_123342_();
            int tez = pos.m_123343_();
            Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82520_((double)(-tex), (double)(-tey), (double)(-tez));
            Vector3f start = new Vector3f(0.5f, 0.8f, 0.5f);
            Vector3f end = new Vector3f((float)destination.m_123341_() + 0.5f, (float)destination.m_123342_() + 0.5f, (float)destination.m_123343_() + 0.5f);
            Vector3f player = new Vector3f((float)projectedView.f_82479_, (float)projectedView.f_82480_, (float)projectedView.f_82481_);
            Matrix4f matrix = matrixStack.m_85850_().m_85861_();
            if (startupFactor > 0.8f) continue;
            if (startupFactor > 0.001f) {
                Vector3f middle = new Vector3f(this.jitter(startupFactor, start.m_122239_(), end.m_122239_()), this.jitter(startupFactor, start.m_122260_(), end.m_122260_()), this.jitter(startupFactor, start.m_122269_(), end.m_122269_()));
                RenderHelper.drawBeam((Matrix4f)matrix, (VertexConsumer)builder, (TextureAtlasSprite)sprite, (Vector3f)start, (Vector3f)middle, (Vector3f)player, (RenderSettings)SETTINGS_LASER);
                RenderHelper.drawBeam((Matrix4f)matrix, (VertexConsumer)builder, (TextureAtlasSprite)sprite, (Vector3f)middle, (Vector3f)end, (Vector3f)player, (RenderSettings)SETTINGS_LASER);
                continue;
            }
            RenderHelper.drawBeam((Matrix4f)matrix, (VertexConsumer)builder, (TextureAtlasSprite)sprite, (Vector3f)start, (Vector3f)end, (Vector3f)player, (RenderSettings)SETTINGS_LASER);
        }
    }

    private float jitter(float startupFactor, float a1, float a2) {
        return (a1 + a2) / 2.0f + (this.random.nextFloat() * 2.0f - 1.0f) * startupFactor;
    }
}

